IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[P_EST_PROD_PRECO_DROGASMIL]') AND TYPE IN (N'P', N'PC'))
DROP PROCEDURE [DBO].[P_EST_PROD_PRECO_DROGASMIL]
GO

--DROP PROCEDURE EXEC P_EST_PROD_PRECO_DROGASMIL 101,'20160823',0
CREATE PROCEDURE [DBO].[P_EST_PROD_PRECO_DROGASMIL](
	@CD_FILIAL INT = 0,
	@DATA DATE,
	@CD_PROD_ESP INT = 0
)       

-- EXEC [P_EST_PROD_PRECO_DROGASMIL] 3, '20160225', 2140034

AS      

BEGIN

DECLARE @DATA_ATUAL DATE = CONVERT(DATE, @DATA);
DECLARE @AJUSTAR_DEPARA INT

SET NOCOUNT ON

-- DROP TABLE #RS_RETORNO

CREATE TABLE #RS_RETORNO (
    CD_EMP INT,
	CD_FILIAL INT,
	CD_PROD INT,
	DS_PROD VARCHAR(200),
	CD_BARRA VARCHAR(20),
	GRUPO1 INT,
	PRODUTO_CONTROLADO INT,
	VLR_CUSTO MONEY,
	VLR_PMC MONEY,
	VLR_PROD MONEY,
	PERC_DESC MONEY,
	CD_FABRIC INT,
	APRES_QT_CP INT,
	VLR_PROD_FARM_POPU MONEY,
	PERC_COMIS MONEY,
	TERMO_LABEL INT,	 
	REQUER_RECEITA INT,
	REGISTRO_MS VARCHAR(50),
	TP_REF_MED VARCHAR(2),
	NR_NCM VARCHAR(50),
	PIS_COFINS INT,
	STS_PROD INT,
	CD_ARV_MERC_LINHA INT,
	UNIDADE VARCHAR(10),
	SAL INT,
	ICMS INT,
	PERC_ICMS_EST MONEY,
	ALIQUOTA_ECF VARCHAR(5),
	PERC_IBPT MONEY,
	VLR_CONV1 MONEY,
	VLR_CONV2 MONEY,
	VLR_CONV3 MONEY,
	VLR_CONV4 MONEY,
	VLR_CONV5 MONEY,
	VLR_CONV6 MONEY,
	VLR_CONV7 MONEY,
	VLR_CONV8 MONEY,
	VLR_CONV9 MONEY,
	VLR_CONV10 MONEY,
	VLR_CONV11 MONEY,
	VLR_CONV12 MONEY,
	NM_FABRICANTE VARCHAR(150),
	IDX_TRIBUTACAO_EXTENDIDA INT,
	VLR_BASE_CALCULO MONEY,
	QTDE_PONTOS INT,
	NR_CEST VARCHAR(20))

CREATE TABLE #RS_PRODUTOS (
	CD_EMP INT,
	CD_FILIAL INT,
	CD_PROD INT,
	CD_FABRIC INT,
	CD_UN_VD INT,
	DS_PROD VARCHAR(200),
	FLAG_PRODUTO_CONTROLADO INT,
	PERC_COMIS MONEY,
	TERMO_LABEL MONEY,
	FLAG_REQUER_RECEIT INT,
	NR_REG_MS VARCHAR(200),
	FLAG_PRODUTO_ETICO INT,
	FLAG_PRODUTO_GENERICO INT,
	FLAG_PRODUTO_SIMILAR INT,
	NR_NCM VARCHAR(15),
	PIS_COFINS INT,
	STS_PROD INT,
	PERC_IBPT MONEY,
	CD_TRIB INT,
	ICMS INT,
	PERC_ICMS_EST MONEY,
	ISENTO INT,
	PERC_RED MONEY,
	NM_FABRIC VARCHAR(150),
	SAL VARCHAR(500),
	REQUER_RECEITA INT,
	CD_BARRA VARCHAR(20),
	VLR_CUSTO MONEY,
	NR_CEST VARCHAR(20))

CREATE TABLE #RS_DESCONTO_PROG (
	CD_FILIAL INT,
	CD_PROD INT,
	PERC_DESC MONEY)

CREATE TABLE #RS_DESCONTO_CARGO (
	CD_FILIAL INT,
	CD_PROD INT,
	PERC_DESC MONEY)

CREATE TABLE #RS_PRECO (
	CD_EMP INT,
	CD_FILIAL INT,
	CD_PROD INT,
	VLR_PRODUTO MONEY,
	VLR_TABELA MONEY,
	VLR_OFERTA MONEY)

PRINT 'INSERINDO PRODUTOS ' + CONVERT(VARCHAR,GETDATE(),108)		
INSERT INTO 
	#RS_PRODUTOS
SELECT 
	CPL.CD_EMP, 
	CPL.CD_FILIAL, 
	CPL.CD_PROD,
	PROD.CD_FABRIC,
	PROD.CD_UN_VD,
	PROD.DS_PROD,
	--PROD.FLAG_PRODUTO_CONTROLADO,
	(CASE WHEN ISNULL(PROD.CTR_PMC,0) = 1  THEN
		(CASE WHEN (PROD.FLAG_PRODUTO_CONTROLADO  + PROD.ANTIBIOTICO) = 0 THEN
			3
		WHEN PROD.ANTIBIOTICO = 1 THEN
			2
		WHEN PROD.FLAG_PRODUTO_CONTROLADO = 1 THEN
					1
		END)
	ELSE
			0
	END) AS FLAG_PRODUTO_CONTROLADO,
	PROD.PERC_COMIS,
	--ISNULL(TBL_PERC_COMIS.PERC_COMIS,PROD.PERC_COMIS) AS PERC_COMIS,
	PROD.TERMO_LABEL,
	PROD.FLAG_REQUER_RECEIT,
	PROD.NR_REG_MS,
	PROD.FLAG_PRODUTO_ETICO,
	PROD.FLAG_PRODUTO_GENERICO,
	PROD.FLAG_PRODUTO_SIMILAR,
	PROD.NR_NCM,
	PROD.PIS_COFINS,
	PROD.STS_PROD,
	TRIB.CD_TRIB,
	EST.PERC_IBPT,
	TRIB.ICMS,
	EST.PERC_ICMS_EST,
	TRIB.ISENTO,
	EST.PERC_RED,
	EST_PROD_FABRIC.NM_FABRIC,
	COALESCE(SAL.CD_PRINC_ATIVOS,0) AS SAL,
	COALESCE(DIVER.OBRIG_RECEITA,PROD.FLAG_REQUER_RECEIT,0),
	--(SELECT TOP 1 CD_BARRA FROM EST_PROD_CD_BARRA WHERE CD_EMP = CPL.CD_EMP AND CD_PROD = CPL.CD_PROD AND NAO_EXPORTAR = 0) CD_BARRA,
	ISNULL(EST_PROD_CD_BARRA.CD_BARRA,'') AS CD_BARRA,
	CPL.VLR_CUSTO,
	COALESCE(PROD.NR_CEST,'') AS NR_CEST
FROM 
	EST_PROD_CPL CPL INNER JOIN EST_PROD PROD ON
	CPL.CD_EMP = PROD.CD_EMP AND 
	CPL.CD_PROD = PROD.CD_PROD
	
	LEFT JOIN EST_PROD_CPL_TRIB_EST AS EST ON 
	CPL.CD_PROD = EST.CD_PROD  AND 
	CPL.CD_FILIAL = EST.CD_FILIAL  AND 
	CPL.CD_EMP = EST.CD_EMP  AND 
	EST.TP_MOV = 0  AND 
	EST.TP_TRANSA = 1
	
	LEFT JOIN EST_TRIB AS TRIB ON
	EST.CD_TRIB = TRIB.CD_TRIB
	
	LEFT OUTER JOIN EST_PROD_FABRIC ON
	PROD.CD_FABRIC = EST_PROD_FABRIC.CD_FABRIC
	
	LEFT JOIN EST_PROD_PRINC_ATIVOS_EST_PROD AS SAL ON 
	SAL.CD_EMP = PROD.CD_EMP  AND 
	SAL.CD_PROD = PROD.CD_PROD 
	
	LEFT JOIN EST_PROD_INF_DIVERS AS DIVER ON 
	PROD.CD_EMP = DIVER.CD_EMP  AND 
	PROD.CD_PROD = DIVER.CD_PROD 
	
	LEFT JOIN EST_PROD_CD_BARRA ON
	PROD.CD_EMP = EST_PROD_CD_BARRA.CD_EMP AND 
	PROD.CD_PROD = EST_PROD_CD_BARRA.CD_PROD AND
	EST_PROD_CD_BARRA.NAO_EXPORTAR=0 AND
	EST_PROD_CD_BARRA.EAN_CAIXA_FECHADA = 0
	
	--LEFT JOIN EST_PROD_TBL_COMIS_PRC_FILIAL FIL ON
	--FIL.CD_EMP = CPL.CD_EMP AND
	--FIL.CD_FILIAL = CPL.CD_FILIAL 

	--LEFT JOIN EST_PROD_TBL_COMIS_EST_PROD TBL_PERC_COMIS ON
	--TBL_PERC_COMIS.CD_EMP = PROD.CD_EMP AND
	--TBL_PERC_COMIS.CD_TBL_COMIS = PROD.CD_TBL_COMIS
	
WHERE 
	CPL.CD_EMP = 1 
	AND CPL.TP_PROD IN (0, 8, 9, 10, 11) 
	AND PROD.STS_PROD IN (0,2)
	AND CPL.CD_FILIAL =  @CD_FILIAL
	AND CPL.CD_PROD = CASE WHEN @CD_PROD_ESP = 0 THEN CPL.CD_PROD ELSE @CD_PROD_ESP END


PRINT 'INSERINDO DESCONTO PROGRAMADO ' + CONVERT(VARCHAR,GETDATE(),108)	
--PEGANDO O DESCONTO POR PERÍODO
--ESTE DESCONTO SERÁ "CHAPADO" NO PREÇO DO PRODUTO
--OU SEJA, O PREÇO FINAL DO PRODUTO SERÁ O VALOR TABELA MENOS O PERCENTUAL DE DESCONTO
--DESDE QUE O PRODUTO NÃO TENHA VALOR OFERTA (VALOR OFERTA É O PRIMEIRO NA REGRA DE PRECEDÊNCIA)
INSERT INTO 
	#RS_DESCONTO_PROG
SELECT
	EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_FILIAL,
	ISNULL(TBPROD.CD_PROD,EST_PROD_PRECO_DESC_PRG_CPL.CD_PROD) AS CD_PROD,
	MAX(EST_PROD_PRECO_DESC_PRG_CPL.PERC_DESC)
FROM
	EST_PROD_PRECO_DESC_PRG		
	INNER JOIN EST_PROD_PRECO_DESC_PRG_CPL ON
		EST_PROD_PRECO_DESC_PRG.CD_PRECO_PRG = EST_PROD_PRECO_DESC_PRG_CPL.CD_PRECO_PRG
		AND EST_PROD_PRECO_DESC_PRG_CPL.CD_EMP = 1
	INNER JOIN #RS_PRODUTOS TBPROD ON
		EST_PROD_PRECO_DESC_PRG_CPL.CD_EMP = TBPROD.CD_EMP
		AND EST_PROD_PRECO_DESC_PRG_CPL.CD_PROD = TBPROD.CD_PROD
	INNER JOIN EST_PROD_PRECO_DESC_PRG_PRC_FILIAL ON
		EST_PROD_PRECO_DESC_PRG.CD_PRECO_PRG = EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_PRECO_PRG
		AND EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_EMP = 1
		AND TBPROD.CD_FILIAL = EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_FILIAL
WHERE 
	EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_FILIAL = @CD_FILIAL 
	AND @DATA_ATUAL BETWEEN EST_PROD_PRECO_DESC_PRG.DT_INI AND EST_PROD_PRECO_DESC_PRG.DT_VENCTO
GROUP BY
	EST_PROD_PRECO_DESC_PRG_PRC_FILIAL.CD_FILIAL,
	EST_PROD_PRECO_DESC_PRG_CPL.CD_PROD,TBPROD.CD_PROD;


PRINT 'INSERINDO VALORES DE VENDAS ' + CONVERT(VARCHAR,GETDATE(),108)	
INSERT INTO
	#RS_PRECO
SELECT
	P.CD_EMP,
	P.CD_FILIAL,
	TBPROD.CD_PROD,
	P.VLR_TABELA,
	P.VLR_TABELA,
	P.VLR_OFERTA
FROM 
	EST_PROD_PRECO P INNER JOIN #RS_PRODUTOS TBPROD ON
	P.CD_EMP = TBPROD.CD_EMP AND 
	P.CD_FILIAL = TBPROD.CD_FILIAL AND 
	P.CD_PROD = TBPROD.CD_PROD
WHERE
	P.CD_EMP = 1
	AND P.CD_FILIAL = @CD_FILIAL

PRINT 'INSERINDO DESCONTO POR CARGO ' + CONVERT(VARCHAR,GETDATE(),108)	

--PEGANDO O DESCONTO POR CARGO
INSERT INTO 
	#RS_DESCONTO_CARGO
SELECT
	EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_FILIAL,
	ISNULL(TBPROD.CD_PROD,EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_PROD) AS CD_PROD,
	MAX(EST_PROD_TBL_DESC_CARGO_EST_PROD.PERC_DESC)
FROM
	EST_PROD_TBL_DESC_CARGO INNER JOIN EST_PROD_TBL_DESC_CARGO_PRC_FILIAL ON
	EST_PROD_TBL_DESC_CARGO.CD_EMP = EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_EMP AND 
	EST_PROD_TBL_DESC_CARGO.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_TBL_DESC_CARGO
	
	INNER JOIN EST_PROD_TBL_DESC_CARGO_EST_PROD ON
	EST_PROD_TBL_DESC_CARGO.CD_EMP = EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_EMP AND 
	EST_PROD_TBL_DESC_CARGO.CD_TBL_DESC_CARGO = EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_TBL_DESC_CARGO
	INNER JOIN #RS_PRODUTOS TBPROD ON
	EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_EMP = TBPROD.CD_EMP AND 
	EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_PROD = TBPROD.CD_PROD AND 
	EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_FILIAL = TBPROD.CD_FILIAL
WHERE
	EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_FILIAL = @CD_FILIAL
	AND EST_PROD_TBL_DESC_CARGO.STS_TBL IN (0,1)
GROUP BY
	EST_PROD_TBL_DESC_CARGO_PRC_FILIAL.CD_FILIAL,
	EST_PROD_TBL_DESC_CARGO_EST_PROD.CD_PROD,TBPROD.CD_PROD;

PRINT 'CRIANDO INDICES ' + CONVERT(VARCHAR,GETDATE(),108)	
CREATE  CLUSTERED INDEX PKRSPRODUTOS ON #RS_PRODUTOS (CD_PROD,CD_FILIAL,CD_EMP);		
CREATE UNIQUE CLUSTERED INDEX PKRSDESCONTO ON #RS_DESCONTO_PROG (CD_FILIAL,CD_PROD);		
CREATE UNIQUE CLUSTERED INDEX PKRSDESCONTOCARGO ON #RS_DESCONTO_CARGO (CD_FILIAL,CD_PROD);		
CREATE  CLUSTERED INDEX PKRSPRECO ON #RS_PRECO (CD_EMP, CD_FILIAL, CD_PROD);		

PRINT 'VALIDANDO VALOR DE VENDA COM O OFETA ' + CONVERT(VARCHAR,GETDATE(),108)	
--SE TEM VALOR OFERTA, O VALOR DE VENDA DO PRODUTO É O PRÓPRIO VALOR OFERTA
--SENÃO, TESTA SE TEM DESCONTO POR PERÍODO. SE TEM, APLICA ESSE DESCONTO NO PREÇO DE VENDA DO PRODUTO
--SENÃO, O VALOR DE VENDA DO PRODUTO É O VALOR DE TABELA
UPDATE 
	P
SET 
	P.VLR_PRODUTO = 
	CASE WHEN P.VLR_OFERTA > 0 THEN
		P.VLR_OFERTA
	ELSE
		CASE WHEN D.PERC_DESC > 0 THEN
			P.VLR_TABELA - (P.VLR_TABELA * COALESCE(D.PERC_DESC,0) / 100)
		ELSE
			P.VLR_TABELA
		END
	END
FROM
	#RS_PRECO P LEFT JOIN #RS_DESCONTO_PROG D ON
	P.CD_FILIAL = D.CD_FILIAL AND 
	P.CD_PROD = D.CD_PROD


PRINT 'INSERINDO O RETORNO ' + CONVERT(VARCHAR,GETDATE(),108)	
INSERT INTO 
	#RS_RETORNO 
SELECT 
	DISTINCT 
	PR.CD_EMP,
	PR.CD_FILIAL,
	PR.CD_PROD,
	PR.DS_PROD,
	PR.CD_BARRA,	
	CASE WHEN CD_ARV_MERC_LINHA IN (15,81) THEN 5 
		WHEN CD_ARV_MERC_LINHA IN (8,82) THEN 9
		WHEN CD_ARV_MERC_LINHA IN (5,6,7) OR PR.FLAG_PRODUTO_CONTROLADO = 1 THEN 2
		WHEN CD_ARV_MERC_LINHA IN (9) THEN 7 
		ELSE 1 
	END AS GRUPO1,
	PR.FLAG_PRODUTO_CONTROLADO,
	ROUND(PR.VLR_CUSTO,2) AS VLR_CUSTO,
	PRE.VLR_TABELA AS VLR_PMC,
	PRE.VLR_PRODUTO AS VLR_PROD,
	COALESCE(DESC_CARGO.PERC_DESC,0) AS PERC_DESC,
	PR.CD_FABRIC,
	CAST(COALESCE(FARM_POPU.QT_COMPR_EMB_CX,1) AS INT) AS APRES_QT_CP,
	COALESCE(FARM_POPU.VLR_PROD,0) AS VLR_PROD_FARM_POPU,
	COALESCE(PR.PERC_COMIS,0) AS PERC_COMIS,
	COALESCE(PR.TERMO_LABEL,0) AS TERMO_LABEL,
	PR.REQUER_RECEITA,
	COALESCE(PR.NR_REG_MS,'') AS REGISTRO_MS,

	CASE WHEN PR.FLAG_PRODUTO_ETICO = 1 THEN 
		'R' 
	ELSE 
		CASE WHEN PR.FLAG_PRODUTO_GENERICO = 1 THEN 
			'G' 
		ELSE 
			CASE WHEN PR.FLAG_PRODUTO_SIMILAR = 1 THEN 
				'S' 
			ELSE 
				'N' 
			END 
		END 
	END AS TP_REF_MED,

	PR.NR_NCM,
	PR.PIS_COFINS,
	PR.STS_PROD,
	LINHA.CD_ARV_MERC_LINHA,
	UN.DS_UN AS UNIDADE,
	PR.SAL,
	COALESCE(PR.ICMS,0) AS ICMS,
	LEFT(COALESCE(PERC_ICMS_EST,0),2) AS PERC_ICMS_EST,
	CASE WHEN PR.ICMS = 1 THEN 'T' WHEN PR.ISENTO = 1 THEN 'I' ELSE 'F' END AS ALIQUOTA_ECF,
	COALESCE(PR.PERC_IBPT,0) AS PERC_IBPT,

	--VALORES DE CONVÊNIO
	ROUND(CASE WHEN COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_1)/100),PRE.VLR_PRODUTO) > PRE.VLR_PRODUTO THEN PRE.VLR_PRODUTO ELSE COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_1)/100),PRE.VLR_PRODUTO) END ,2),
	ROUND(CASE WHEN COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_2)/100),PRE.VLR_PRODUTO) > PRE.VLR_PRODUTO THEN PRE.VLR_PRODUTO ELSE COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_2)/100),PRE.VLR_PRODUTO) END ,2),
	ROUND(CASE WHEN COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_3)/100),PRE.VLR_PRODUTO) > PRE.VLR_PRODUTO THEN PRE.VLR_PRODUTO ELSE COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_3)/100),PRE.VLR_PRODUTO) END ,2),
	ROUND(CASE WHEN COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_4)/100),PRE.VLR_PRODUTO) > PRE.VLR_PRODUTO THEN PRE.VLR_PRODUTO ELSE COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_4)/100),PRE.VLR_PRODUTO) END ,2),
	ROUND(CASE WHEN COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_5)/100),PRE.VLR_PRODUTO) > PRE.VLR_PRODUTO THEN PRE.VLR_PRODUTO ELSE COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_5)/100),PRE.VLR_PRODUTO) END ,2),
	ROUND(CASE WHEN COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_6)/100),PRE.VLR_PRODUTO) > PRE.VLR_PRODUTO THEN PRE.VLR_PRODUTO ELSE COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_6)/100),PRE.VLR_PRODUTO) END ,2),
	ROUND(CASE WHEN COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_7)/100),PRE.VLR_PRODUTO) > PRE.VLR_PRODUTO THEN PRE.VLR_PRODUTO ELSE COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_7)/100),PRE.VLR_PRODUTO) END ,2),
	ROUND(CASE WHEN COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_8)/100),PRE.VLR_PRODUTO) > PRE.VLR_PRODUTO THEN PRE.VLR_PRODUTO ELSE COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_8)/100),PRE.VLR_PRODUTO) END ,2),
	ROUND(CASE WHEN COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_9)/100),PRE.VLR_PRODUTO) > PRE.VLR_PRODUTO THEN PRE.VLR_PRODUTO ELSE COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_9)/100),PRE.VLR_PRODUTO) END ,2),
	ROUND(CASE WHEN COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_10)/100),PRE.VLR_PRODUTO) > PRE.VLR_PRODUTO THEN PRE.VLR_PRODUTO ELSE COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_10)/100),PRE.VLR_PRODUTO) END ,2),
	ROUND(CASE WHEN COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_11)/100),PRE.VLR_PRODUTO) > PRE.VLR_PRODUTO THEN PRE.VLR_PRODUTO ELSE COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_11)/100),PRE.VLR_PRODUTO) END ,2),
	ROUND(CASE WHEN COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_12)/100),PRE.VLR_PRODUTO) > PRE.VLR_PRODUTO THEN PRE.VLR_PRODUTO ELSE COALESCE(PRE.VLR_TABELA-((PRE.VLR_TABELA*PERC_DESC_12)/100),PRE.VLR_PRODUTO) END ,2),

	NM_FABRIC,
	PR.CD_TRIB AS IDX_TRIBUTACAO_EXTENDIDA,
	COALESCE(PRE.VLR_PRODUTO - (PRE.VLR_PRODUTO * COALESCE(PERC_RED,0) / 100),0) AS VLR_BASE_CALCULO,

	COALESCE((SELECT TOP 1 QTDE_PONTO FROM UFD_EST_PROD_TBL_FIDEL_PONTUACAO(PR.CD_EMP,PR.CD_FILIAL,PR.CD_PROD)),0) AS QTDE_PONTO_FIDEL,
	PR.NR_CEST
FROM
	#RS_PRODUTOS PR INNER JOIN #RS_PRECO PRE ON
	PR.CD_EMP = PRE.CD_EMP AND 
	PR.CD_FILIAL = PRE.CD_FILIAL AND 
	PR.CD_PROD = PRE.CD_PROD

	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS LINHA ON 
	PR.CD_EMP = LINHA.CD_EMP  AND 
	PR.CD_PROD = LINHA.CD_PROD

	LEFT OUTER JOIN V_TBL_DESC_CONVENIO_DROGASMIL ON
	PR.CD_EMP = V_TBL_DESC_CONVENIO_DROGASMIL.CD_EMP AND
	PR.CD_PROD = V_TBL_DESC_CONVENIO_DROGASMIL.CD_PROD

	LEFT JOIN #RS_DESCONTO_CARGO DESC_CARGO ON 
	PR.CD_FILIAL = DESC_CARGO.CD_FILIAL AND 
	PR.CD_PROD = DESC_CARGO.CD_PROD

	LEFT JOIN EST_PROD_UN_MED AS UN ON 
	PR.CD_EMP = UN.CD_EMP AND 
	PR.CD_UN_VD = UN.CD_CTR_UN

	LEFT JOIN EST_PROD_FARMACIA_POPULAR AS FARM_POPU ON 
	FARM_POPU.CD_EMP = PR.CD_EMP AND 
	FARM_POPU.CD_PROD = PR.CD_PROD
	
WHERE 
	PR.CD_EMP = 1 
	AND PR.CD_FILIAL = @CD_FILIAL

ORDER BY 
	CD_PROD

--- VALIDANDO SE VAI FAZER O DEPARA OU NÃO
SET @AJUSTAR_DEPARA = ISNULL((SELECT TOP 1 FLAG_CONTROLE_DEPARA FROM V_CAD_UNICO_DEPARAS_PRC_FILIAL WHERE CD_FILIAL = @CD_FILIAL),0)

----- ALTERANDO REGISTROS PARA PEGAR O CODIGO DO DEPARA DE CADA BANDEIRA
IF @AJUSTAR_DEPARA <> 0 
	BEGIN 
		---	 RETORNA APENAS PRODUTOS QUE TENHA VINCULO DE DEPARA
		SELECT 
			RET.CD_EMP,
			RET.CD_FILIAL,
			VPU.CD_PROD_BANDEIRA AS CD_PROD,
			--RET.DS_PROD,
			DESC_PROD.DS_PROD,
			RET.CD_BARRA,
			(CASE WHEN FIL.CD_BANDEIRA = 3 THEN 
				ISNULL(VPL.CD_CTR_FK,0)
			 ELSE 
				RET.GRUPO1
			 END) AS GRUPO1,
			RET.PRODUTO_CONTROLADO,
			RET.VLR_CUSTO,
			RET.VLR_PMC,
			RET.VLR_PROD,
			--RET.PERC_DESC,
			ISNULL(TBL_PERC_COMIS,0) AS PERC_COMIS,
			RET.CD_FABRIC,
			RET.APRES_QT_CP,
			RET.VLR_PROD_FARM_POPU,
			RET.PERC_COMIS,
			RET.TERMO_LABEL, 
			RET.REQUER_RECEITA,
			RET.REGISTRO_MS,
			RET.TP_REF_MED,
			RET.NR_NCM,
			RET.PIS_COFINS,
			RET.STS_PROD,
			RET.CD_ARV_MERC_LINHA,
			RET.UNIDADE,
			RET.SAL,
			RET.ICMS,
			RET.PERC_ICMS_EST,
			RET.ALIQUOTA_ECF,
			RET.PERC_IBPT,
			RET.VLR_CONV1,
			RET.VLR_CONV2,
			RET.VLR_CONV3,
			RET.VLR_CONV4,
			RET.VLR_CONV5,
			RET.VLR_CONV6,
			RET.VLR_CONV7,
			RET.VLR_CONV8,
			RET.VLR_CONV9,
			RET.VLR_CONV10,
			RET.VLR_CONV11,
			RET.VLR_CONV12,
			RET.NM_FABRICANTE,
			RET.IDX_TRIBUTACAO_EXTENDIDA,
			RET.VLR_BASE_CALCULO,
			RET.QTDE_PONTOS,
			RET.NR_CEST		
			FROM 
				#RS_RETORNO RET 
				INNER JOIN V_CAD_UNICO_DEPARAS_EST_PROD VPU ON
				VPU.CD_PROD = RET.CD_PROD AND
				VPU.CD_FILIAL = RET.CD_FILIAL 		

				INNER JOIN PRC_BANDEIRA_PRC_FILIAL FIL ON
				FIL.CD_FILIAL= VPU.CD_FILIAL 
				
				INNER JOIN EST_PROD_PRC_BANDEIRA DESC_PROD ON
				DESC_PROD.CD_BANDEIRA=VPU.CD_BANDEIRA AND
				DESC_PROD.CD_PROD=VPU.CD_PROD 

				LEFT JOIN CAD_UNICO_DEPARAS VPL ON
				VPL.TABELA = 'EST_ARV_MERC_LINHA'
				AND VPL.BANDEIRA = FIL.CD_BANDEIRA
				AND VPL.CD_CTR_PK = RET.CD_ARV_MERC_LINHA

				LEFT JOIN EST_PROD_TBL_COMIS_EST_PROD TBL_PERC_COMIS ON
				TBL_PERC_COMIS.CD_PROD = VPU.CD_PROD
					
			WHERE FIL.FLAG_CONTROLE_DEPARA=1
			ORDER BY 
				RET.CD_PROD
	END

IF @AJUSTAR_DEPARA = 0
	BEGIN
		SELECT * FROM #RS_RETORNO ORDER BY CD_PROD
	END

DROP TABLE #RS_PRODUTOS
DROP TABLE #RS_DESCONTO_PROG 
DROP TABLE #RS_DESCONTO_CARGO 
DROP TABLE #RS_PRECO
DROP TABLE #RS_RETORNO

RETURN

END


GO


